/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynamic;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.transformer.operation.ModifyMixinType;
import org.sinytra.adapter.patch.util.MockMixinRuntime;
import org.spongepowered.asm.mixin.injection.modify.LocalVariableDiscriminator;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.Target;

public class DynamicModifyVarAtReturnPatch
implements MethodTransform {
    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/injection/ModifyVariable;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        Object object;
        Pair<AbstractInsnNode, Integer> cleanTargetPair;
        MethodContext.TargetPair dirtyTarget;
        int ordinal;
        block12: {
            block11: {
                Object object2;
                AnnotationHandle injectionPointAnnotation = methodContext.injectionPointAnnotation();
                if (injectionPointAnnotation == null) {
                    return Patch.Result.PASS;
                }
                AnnotationValueHandle targetHandle = injectionPointAnnotation.getValue("value").orElse(null);
                if (targetHandle == null || !((String)targetHandle.get()).equals("RETURN")) {
                    return Patch.Result.PASS;
                }
                ordinal = injectionPointAnnotation.getValue("ordinal").map(AnnotationValueHandle::get).orElse(-1);
                MethodContext.TargetPair cleanTarget = methodContext.findCleanInjectionTarget();
                if (cleanTarget == null) {
                    return Patch.Result.PASS;
                }
                dirtyTarget = methodContext.findDirtyInjectionTarget();
                if (dirtyTarget == null) {
                    return Patch.Result.PASS;
                }
                cleanTargetPair = DynamicModifyVarAtReturnPatch.getTargetPair(classNode, methodNode, methodContext, context, cleanTarget, ordinal);
                if (cleanTargetPair == null || !((object2 = cleanTargetPair.getFirst()) instanceof VarInsnNode)) break block11;
                VarInsnNode cleanVarInsn = (VarInsnNode)object2;
                if (cleanVarInsn.var == (Integer)cleanTargetPair.getSecond()) break block12;
            }
            return Patch.Result.PASS;
        }
        Pair<AbstractInsnNode, Integer> dirtyTargetPair = DynamicModifyVarAtReturnPatch.getTargetPair(classNode, methodNode, methodContext, context, dirtyTarget, ordinal);
        if (dirtyTargetPair == null || !((object = dirtyTargetPair.getFirst()) instanceof MethodInsnNode)) {
            return Patch.Result.PASS;
        }
        MethodInsnNode dirtyMinsn = (MethodInsnNode)object;
        List<AbstractInsnNode> args = MethodCallAnalyzer.findMethodCallParamInsns(dirtyTarget.methodNode(), dirtyMinsn);
        if (args == null) {
            return Patch.Result.PASS;
        }
        Patch.Result result = Patch.Result.PASS;
        for (int i = 0; i < args.size(); ++i) {
            AbstractInsnNode insn = args.get(i);
            if (!(insn instanceof VarInsnNode)) continue;
            VarInsnNode varInsn = (VarInsnNode)insn;
            if (varInsn.var != (Integer)cleanTargetPair.getSecond()) continue;
            if (result != Patch.Result.PASS) {
                return Patch.Result.PASS;
            }
            String qualifier = MethodCallAnalyzer.getCallQualifier(dirtyMinsn);
            int index = i;
            methodContext.recordAudit(this, "Redirect RETURN variable modifier to parameter %s of method call to %s", i, qualifier);
            ModifyMixinType transform = new ModifyMixinType("Lorg/spongepowered/asm/mixin/injection/ModifyArg;", b -> b.sameTarget().injectionPoint("INVOKE", qualifier).putValue("index", index));
            result = transform.apply(classNode, methodNode, methodContext, context);
        }
        return result;
    }

    private static Pair<AbstractInsnNode, Integer> getTargetPair(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context, MethodContext.TargetPair injectionTarget, int ordinal) {
        int index;
        List<AbstractInsnNode> targetInsns = methodContext.findInjectionTargetInsns(injectionTarget);
        if (targetInsns.isEmpty()) {
            return null;
        }
        int n = index = ordinal == -1 ? targetInsns.size() - 1 : ordinal;
        if (index >= targetInsns.size()) {
            return null;
        }
        AbstractInsnNode targetInsn = targetInsns.get(index);
        LocalVariableDiscriminator discriminator = LocalVariableDiscriminator.parse((AnnotationNode)methodContext.methodAnnotation().unwrap());
        InjectionInfo injectionInfo = MockMixinRuntime.forInjectionInfo(classNode.name, injectionTarget.classNode().name, context.environment());
        Type returnType = Type.getReturnType((String)methodNode.desc);
        Target target = MockMixinRuntime.createMixinTarget(injectionTarget);
        LocalVariableDiscriminator.Context ctx = new LocalVariableDiscriminator.Context(injectionInfo, returnType, discriminator.isArgsOnly(), target, targetInsn);
        int local = discriminator.findLocal(ctx);
        return Pair.of((Object)targetInsn, (Object)local);
    }
}

